#include <DpCSSoilSensor.h>

/*
Author: Dubravko Penezic

Version: 1.0, 2014

This code is example how to use DpCSSoilSensor library.

Source code is provided as is, without any warranty.

Distributetd under CC BY v 3.0

http://pcb.daince.net/doku.php?id=arduino_code
*/

DpCSSoilSensor csss_7_9  = DpCSSoilSensor(7,9);  // pin 7 is injector pin, pin  9 is sensor pin
DpCSSoilSensor csss_7_10 = DpCSSoilSensor(7,10); // pin 7 is injector pin, pin 10 is sensor pin
DpCSSoilSensor csss_7_11 = DpCSSoilSensor(7,11); // pin 7 is injector pin, pin 11 is sensor pin
DpCSSoilSensor csss_7_12 = DpCSSoilSensor(7,12); // pin 7 is injector pin, pin 12 is sensor pin

boolean calibrate = true; //false if you found dry and wet value

long csss_7_9_dry = 0;
long csss_7_9_wet = 0;
long csss_7_10_dry = 0;
long csss_7_10_wet = 0;
long csss_7_11_dry = 0;
long csss_7_11_wet = 0;
long csss_7_12_dry = 0;
long csss_7_12_wet = 0;

void setup(){
   // set samples
   csss_7_9.setSamples(40);
   csss_7_10.setSamples(40);
   csss_7_11.setSamples(40);
   csss_7_12.setSamples(40);

   // set timeouts
   csss_7_9.setTimeoutMillis(20000);
   csss_7_10.setTimeoutMillis(20000);
   csss_7_11.setTimeoutMillis(20000);
   csss_7_12.setTimeoutMillis(20000);

   if(! calibrate) {
     csss_7_9.setDry(csss_7_9_dry);
     csss_7_9.setWet(csss_7_9_wet);
     csss_7_10.setDry(csss_7_10_dry);
     csss_7_10.setWet(csss_7_10_wet);
     csss_7_11.setDry(csss_7_11_dry);
     csss_7_11.setWet(csss_7_11_wet);
     csss_7_12.setDry(csss_7_12_dry);
     csss_7_12.setWet(csss_7_12_wet);
   }	
   Serial.begin(9600);
}

void loop()                    
{
    long start = millis();

    if(calibrate) {
      long total1 =  csss_7_9.getRaw();
      long total2 =  csss_7_10.getRaw();
      long total3 =  csss_7_11.getRaw();
      long total4 =  csss_7_12.getRaw();

      Serial.print("CAL (");
      Serial.print(millis() - start);        // check on performance in milliseconds
      Serial.print(")\t 7->9\t");
      Serial.print(total1);                  // print sensor output 1
      Serial.print("\t 7->10\t");
      Serial.print(total2);                  // print sensor output 2
      Serial.print("\t 7->11\t");
      Serial.print(total3);                  // print sensor output 3
      Serial.print("\t 7->12\t");
      Serial.println(total4);                // print sensor output 4

      delay(5000);                           // arbitrary delay to limit data to serial port
    } else {
      float value1 =  csss_7_9.getValue();
      value1 = ((int)(value1 * 100 ))/ 100.0;
      float value2 =  csss_7_10.getValue();
      value2 = ((int)(value2 * 100 ))/ 100.0;
      float value3 =  csss_7_11.getValue();
      value3 = ((int)(value3 * 100 ))/ 100.0;
      float value4 =  csss_7_12.getValue();
      value4 = ((int)(value4 * 100 ))/ 100.0;

      Serial.print("MES (");
      Serial.print(millis() - start);        // check on performance in milliseconds
      Serial.print(")\t 7->9\t");
      Serial.print(value1);                  // print sensor output 1
      Serial.print(" %\t 7->10\t");
      Serial.print(value2);                  // print sensor output 2
      Serial.print(" %\t 7->11\t");
      Serial.print(value3);                  // print sensor output 3
      Serial.print(" %\t 7->12\t");
      Serial.print(value4);                  // print sensor output 4
      Serial.println(" %");

      delay(5000);                           // arbitrary delay to limit data to serial port
    }
}
