/*
 * Author: Dubravko Penezic
 *
 * Version: 1.0, 2014
 *
 * DpCSSoilSensor.h - Library definition of DpCSSoilSensor class
 *
 * DpCSSoilSensor Arduino library provide function for gething
 * data form Capacitive Soil Sensor.
 *
 * Most part of code come from original CapSense library !
 *
 * Source code is provided as is, without any warranty.
 *
 * Distributetd under CC BY v 3.0
 *
 * http://pcb.daince.net/doku.php?id=arduino_code
 * */

// ensure this library description is only included once
#ifndef DpCSSoilSensor_h
#define DpCSSoilSensor_h

#if ARDUINO >= 100
#include "Arduino.h"
#else
#include "WProgram.h"
#endif

class DpCSSoilSensor {
  public:
// Initialisation method which set sendPin and receivePin
    DpCSSoilSensor(uint8_t sendPin, uint8_t receivePin);

// set number of samples
    void setSamples(uint8_t samp);

// get number of samples
    uint8_t getSamples();

// set timeout in milliseconds
    void setTimeoutMillis(unsigned long timeoutm);

// get timeout in milliseconds
    unsigned long getTimeoutMillis();

// set dry capacitive value
    void setDry(long CSValue);

// get preset dry value
    long getDry();

// set wet capacitive value
    void setWet(long CSValue);

// get preset wet value
    long getWet();

// get raw capacitive data
    long getRaw();

// return percentage of wetnes or error code 
// -2 - measuring timeout
// -10 - no measuring
// -20 - wrong pin
// -41 - higher then wet value
// -42 - lover then dry value
    float getValue();
  private:
    int error;
    uint8_t samples;
    long CS_SS_Dry;
    long CS_SS_Wet;
    unsigned long  leastTotal;
    unsigned int   loopTimingFactor;
    unsigned long  CS_Timeout_Millis;
    unsigned long  timeoutMillis;
    unsigned long  lastCal;
    unsigned long  total;
    uint8_t sBit;   // send pin's ports and bitmask
    volatile uint8_t *sReg;
    volatile uint8_t *sOut;
    uint8_t rBit;    // receive pin's ports and bitmask 
    volatile uint8_t *rReg;
    volatile uint8_t *rIn;
    volatile uint8_t *rOut;
    int SenseOneCycle(void);
};

#endif
